# Copyright 1999-2006 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/net-www/gnash/gnash-0.7_alpha20060129.ebuild,v 1.2 2006/01/31 02:47:20 mr_bones_ Exp $

inherit cvs

DESCRIPTION="Gnash is a GNU Flash movie player that supports many SWF v7 features"
HOMEPAGE="http://www.gnu.org/software/gnash"
SRC_URI=""
ECVS_SERVER="cvs.sv.gnu.org:/sources/${PN}"
ECVS_MODULE="${PN}"
ECVS_CO_OPTS="-D ${PV/0.7_alpha}"
ECVS_UP_OPTS="-dP ${ECVS_CO_OPTS}"
S=${WORKDIR}/${ECVS_MODULE}

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~ppc ~x86 ~amd64"
IUSE="http dmalloc mp3 xml2 firefox mozilla dom xmlreader pthreads test konqueror"

DEPEND="virtual/opengl
	media-libs/jpeg
	media-libs/libpng
	sys-libs/zlib
	|| (
		( x11-libs/libX11
		x11-libs/libXt
		x11-proto/xproto )
		virtual/x11 )
	xml2? ( dev-libs/libxml2 )
	media-libs/libsdl 
	media-libs/sdl-mixer
	mp3? ( media-libs/libmad )
	media-libs/libogg
	media-libs/nas"

RDEPEND="${DEPEND}"

src_unpack() {
	cvs_src_unpack
	cd ${S}
	pwd
	# Put patch here
	epatch ${FILESDIR}/gnash_*.patch
}

pkg_setup() {
	if use dom && use xmlreader ; then
		ewarn "Trying to build with dom support and with xmlreader support."
		ewarn "Dom support will be disabled."
	fi	
}

src_compile() {
	libtoolize --copy --force || die "libtoolize --copy --force failed"
	./autogen.sh || die "autogen.sh failed"
	# See bug : #15663
	# http://savannah.gnu.org/bugs/?func=detailitem&item_id=15663
	#use firefox && export PATH=$PATH:/usr/lib/mozilla-firefox
	
	econf \
		$(use_enable mp3 ) \
		$(use_enable pthreads ) \
		$(use_enable dmalloc ) \
		$(use_enable firefox plugin ) \
		$(use_enable konqueror klash ) \
		$(use_enable xml2 xml ) \
		$(useq xmlreader || use_enable dom ) \
		$(use_enable xmlreader ) \
		$(use_enable http ) \
		$(use_enable intel810 i810-lod-bias ) \
		$(use_enable test testing ) \
		--with-plugindir=/usr/lib/mozilla-firefox/plugins \
		--disable-docbook \
		|| die "econf failed"
	emake || die "emake failed"
}

src_install() {
	make DESTDIR=${D} install || die "make install failed"
}

pkg_postinst() {
	ewarn "ALPHA"
	ewarn "gnash is still in heavy development"
	ewarn "please report gnash bugs upstream to the gnash devs"
}
